/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HMCTimerTask;
import java.util.Date;

public final class TimerParms {
    long start = 0L;
    long period = 0L;
    boolean fixedDelay = false;
    Object runParm = null;
    HMCTimerTask task;

    public TimerParms(long delay) {
        this.setStart(delay);
    }

    public TimerParms(Date date) {
        this.setStart(date);
    }

    public TimerParms(long delay, long period, boolean fixedDelay) {
        this.setStart(delay);
        this.setPeriod(period);
        this.setFixedDelay(fixedDelay);
    }

    public TimerParms(Date date, long period, boolean fixedDelay) {
        this.setStart(date);
        this.setPeriod(period);
        this.setFixedDelay(fixedDelay);
    }

    public TimerParms(long delay, long period, boolean fixedDelay, Object runParm) {
        this.setStart(delay);
        this.setPeriod(period);
        this.setFixedDelay(fixedDelay);
        this.setRunParm(runParm);
    }

    public TimerParms(Date date, long period, boolean fixedDelay, Object runParm) {
        this.setStart(date);
        this.setPeriod(period);
        this.setFixedDelay(fixedDelay);
        this.setRunParm(runParm);
    }

    void setTask(HMCTimerTask task) {
        this.task = task;
    }

    public void setRunParm(Object runParm) {
        this.runParm = runParm;
    }

    public void setStart(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("This value must be greater than zero");
        }
        this.start = System.currentTimeMillis() + delay;
    }

    public void setStart(Date start) {
        this.start = start.getTime();
    }

    public void setPeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("This value must be greater than or equal to zero");
        }
        this.period = period;
    }

    public void setFixedDelay(boolean fixedDelay) {
        this.fixedDelay = fixedDelay;
    }
}

